/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootingHandler {
    private static final Map<UUID, EquipmentSlot> LOOTING_OFFHAND = new HashMap<UUID, EquipmentSlot>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLeaveServer);
    }

    public static void setLootingSlot(LivingEntity entity, EquipmentSlot slotType) {
        if (slotType == EquipmentSlot.MAINHAND) {
            LOOTING_OFFHAND.remove(entity.m_142081_());
        } else {
            LOOTING_OFFHAND.put(entity.m_142081_(), slotType);
        }
    }

    public static EquipmentSlot getLootingSlot(@Nullable LivingEntity entity) {
        return entity != null ? LOOTING_OFFHAND.getOrDefault(entity.m_142081_(), EquipmentSlot.MAINHAND) : EquipmentSlot.MAINHAND;
    }

    private static void onLooting(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.m_7639_();
        if (source instanceof LivingEntity) {
            LivingEntity holder = (LivingEntity)source;
            EquipmentSlot slotType = ModifierLootingHandler.getLootingSlot(holder);
            ItemStack held = holder.m_6844_(slotType);
            int level = event.getLootingLevel();
            if (held.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                ToolStack tool = ToolStack.from(held);
                level = ModifierUtil.getLootingLevel(tool, holder, (Entity)event.getEntityLiving(), damageSource);
            } else if (slotType != EquipmentSlot.MAINHAND) {
                level = 0;
            }
            level = ModifierUtil.getLeggingsLootingLevel(holder, (Entity)event.getEntityLiving(), damageSource, level);
            event.setLootingLevel(level);
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        LOOTING_OFFHAND.remove(event.getPlayer().m_142081_());
    }
}

